#include "MeetingApiDelegate.h"
#include "InstantMessageMgr.h"

#include "jcfcoreutils/StringUtils.h"


namespace CSFUnified {

MeetingApiDelegate* MeetingApiDelegate::m_pInstance = NULL;

MeetingApiDelegate::MeetingApiDelegate()
{
    m_pApiDelegateLogger = CSFLogger_getLogger("MeetingService-MeetingApiDelegate");
    CSFLogDebugS(m_pApiDelegateLogger, "MeetingApiDelegate::MeetingApiDelegate()");
    
    m_jabberServiceProvider = &JabberServiceProvider::getInstance();
}

MeetingApiDelegate::~MeetingApiDelegate()
{
}

MeetingApiDelegate* MeetingApiDelegate::getInstance()
{
	if (m_pInstance == NULL)
	{
		m_pInstance = new MeetingApiDelegate();
	}

	return m_pInstance;
}

void MeetingApiDelegate::initJabberAccountName()
{
	CSFLogDebugS(m_pApiDelegateLogger, "Entry MeetingApiDelegate::initJabberAccountName()");

    m_jabberAccountName = m_jabberServiceProvider->getMyAccount();
}

// JM_SDK::IJabberMeetingSDKDelegate
//IM Cmd
void MeetingApiDelegate::sendInstantMeetingInvitation(const PString buddyName,  const PString cmdMsg, const PString htmlMsg, const PString plantMsg)
{
    CSFLogDebugS(m_pApiDelegateLogger, "Entry MeetingApiDelegate::sendInstantMeetingInvitation()");
	InstantMessageMgr::getInstance()->sendMeetingInviteCmd(buddyName.c_str(), cmdMsg.c_str(), htmlMsg.c_str(), plantMsg.c_str());
}

void MeetingApiDelegate::sendInstantMeetingCancelInvitation(const PString buddyName)
{
    CSFLogDebugS(m_pApiDelegateLogger, "Entry MeetingApiDelegate::sendInstantMeetingCancelInvitation()");
	InstantMessageMgr::getInstance()->sendMeetingCancelCmd(buddyName.c_str(), "");
}

void MeetingApiDelegate::sendInstantMeetingDecline(const PString buddyName)
{
    CSFLogDebugS(m_pApiDelegateLogger, "Entry MeetingApiDelegate::sendInstantMeetingDecline()");
	InstantMessageMgr::getInstance()->sendMeetingDeclineCmd(buddyName.c_str(), "");
}

void MeetingApiDelegate::sendDesktopSharingInvitation(const PString buddyName, const PString cmdMsg, const PString htmlMsg, const PString plantMsg)
{
    CSFLogDebugS(m_pApiDelegateLogger, "Entry MeetingApiDelegate::sendDesktopSharingInvitation()");
	InstantMessageMgr::getInstance()->sendDesktopShareInviteCmd(buddyName.c_str(), cmdMsg.c_str(), htmlMsg.c_str(), plantMsg.c_str());
}

void MeetingApiDelegate::sendDesktopSharingCancelInvitation(const PString buddyName)
{
    CSFLogDebugS(m_pApiDelegateLogger, "Entry MeetingApiDelegate::sendDesktopSharingCancelInvitation()");
	InstantMessageMgr::getInstance()->sendDesktopShareCancelCmd(buddyName.c_str(), "");
}

void MeetingApiDelegate::sendDesktopSharingDecline(const PString buddyName)
{
    CSFLogDebugS(m_pApiDelegateLogger, "Entry MeetingApiDelegate::sendDesktopSharingDecline()");
	InstantMessageMgr::getInstance()->sendDesktopShareDeclineCmd(buddyName.c_str(), "");
}

void MeetingApiDelegate::getAttendeeEmail(const PString attendeeJID, PString& attendeeEmail)
{
    CSFLogDebugS(m_pApiDelegateLogger, "MeetingApiDelegate::getAttendeeEmail() attendeeJID = " << attendeeJID.c_str());
    std::string name = "";
    std::string jid = attendeeJID.c_str();
    name = unescapeJid(jid);
    int nPos = name.rfind("@");
    if (nPos == -1)
    {
        attendeeEmail = name.c_str();
        return;
    }
    
    std::string lTemp = name.substr(0, nPos);
    std::string rTemp = name.substr(nPos, name.length());

    replaceAll(lTemp, "@", "40");
    name = lTemp + rTemp;
    attendeeEmail = name.c_str();
    CSFLogDebugS(m_pApiDelegateLogger, "MeetingApiDelegate::getAttendeeEmail() attendeeEmail = " << name.c_str());
}
        
void MeetingApiDelegate::getAttendeeDispalyName(const PString attendeeJID, PString& attendeeDN)
{
    CSFLogDebugS(m_pApiDelegateLogger, "MeetingApiDelegate::getAttendeeDispalyName() attendeeJID = " << attendeeJID.c_str());
    std::string displayName = m_jabberServiceProvider->getDisplayNameByJabberId(attendeeJID.c_str());
    attendeeDN = displayName.c_str();
    CSFLogDebugS(m_pApiDelegateLogger, "MeetingApiDelegate::getAttendeeDispalyName() attendeeDN = " << displayName.c_str());
}

//ds related
void MeetingApiDelegate::hideChatWindow()
{
    
}

void MeetingApiDelegate::showChatWindow()
{

}

void MeetingApiDelegate::onUserTryLeave(bool isHost)
{

}

std::string MeetingApiDelegate::getMyDisplayName()
{
    CSFLogDebugS(m_pApiDelegateLogger, "Entry MeetingApiDelegate::getMyDisplayName()");
    return m_jabberServiceProvider->getMyDisplayName().c_str();
}

    
PString MeetingApiDelegate::getJabberAccountName()
{
    CSFLogDebugS(m_pApiDelegateLogger, "Entry MeetingApiDelegate::getJabberAccountName()");
    return m_jabberAccountName.c_str();
}
	
PString MeetingApiDelegate::getJabberAccountNameFromEmail(const PString email)
{
    CSFLogDebugS(m_pApiDelegateLogger, "Entry MeetingApiDelegate::getJabberAccountNameFromEmail()");
    return m_jabberServiceProvider->getDisplayNameByJabberId(email.c_str()).c_str();
}

//Presence
void MeetingApiDelegate::addInMeetingPresence()
{
    CSFLogDebugS(m_pApiDelegateLogger, "Entry MeetingApiDelegate::addInMeetingPresence()");
    m_jabberServiceProvider->addInMeetingStatus();
}

void MeetingApiDelegate::removeInMeetingPresence()
{
    CSFLogDebugS(m_pApiDelegateLogger, "Entry MeetingApiDelegate::removeInMeetingPresence()");
    m_jabberServiceProvider->removeInMeetingStatus();
}

void MeetingApiDelegate::addInWebExMeetingPresence()
{
    CSFLogDebugS(m_pApiDelegateLogger, "Entry MeetingApiDelegate::addInWebExMeetingPresence()");
    m_jabberServiceProvider->addInWebExMeetingStatus();
}

void MeetingApiDelegate::removeInWebExMeetingPresence()
{
    CSFLogDebugS(m_pApiDelegateLogger, "Entry MeetingApiDelegate::removeInWebExMeetingPresence()");
    m_jabberServiceProvider->removeInWebExMeetingStatus();
}

void MeetingApiDelegate::addInWebExSharingPresence()
{
    CSFLogDebugS(m_pApiDelegateLogger, "Entry MeetingApiDelegate::addInWebExSharingPresence()");
    m_jabberServiceProvider->addSharingInWebExMeetingStatus();
}

void MeetingApiDelegate::removeInWebExSharingPresence()
{
    CSFLogDebugS(m_pApiDelegateLogger, "Entry MeetingApiDelegate::removeInWebExSharingPresence()");
    m_jabberServiceProvider->removeSharingInWebExMeetingStatus();
}

void MeetingApiDelegate::addInDesktopSharingPresence()
{
    CSFLogDebugS(m_pApiDelegateLogger, "Entry MeetingApiDelegate::addInDesktopSharingPresence()");
    m_jabberServiceProvider->addInDSStatus();
}

void MeetingApiDelegate::removeInDesktopSharingPresence()
{
    CSFLogDebugS(m_pApiDelegateLogger, "Entry MeetingApiDelegate::removeInDesktopSharingPresence()");
    m_jabberServiceProvider->removeInDSStatus();
}

void MeetingApiDelegate::addSharingInDesktopSharingPresence()
{
    CSFLogDebugS(m_pApiDelegateLogger, "Entry MeetingApiDelegate::addSharingInDesktopSharingPresence()");
    m_jabberServiceProvider->addSharingInDSStatus();
}

void MeetingApiDelegate::removeShareingInDesktopSharingPresence()
{
    CSFLogDebugS(m_pApiDelegateLogger, "Entry MeetingApiDelegate::removeShareingInDesktopSharingPresence()");
    m_jabberServiceProvider->removeSharingInDSStatus();
}  
    
bool MeetingApiDelegate::isAccount(const PString & sessionName)
{
    std::string jid = getJabberAccountName().c_str();
    
    bool bRtl = false;
    
    if (jid == sessionName.c_str())
    {
        bRtl = true;
    }
    
    CSFLogDebugS(m_pApiDelegateLogger, "MeetingApiDelegate::isAccount() bRtl = " << (bRtl ? "true" : "false"));
    return bRtl;
}

bool MeetingApiDelegate::IsDSPolicyEnable(const PString & sessionName, int & nPolicyResult)
{
    CSFLogDebugS(m_pApiDelegateLogger, "MeetingApiDelegate::IsDSPolicyEnable()");
    
    bool bResult = m_jabberServiceProvider->isDSPolicyEnable(sessionName.c_str(), nPolicyResult);
    
    CSFLogDebugS(m_pApiDelegateLogger, "MeetingApiDelegate::IsDSPolicyEnable() bResult = " << (bResult ? "true" : "false"));
    return bResult;
}
    
bool MeetingApiDelegate::hasDSCapability(const PString & sessionName)
{
    CSFLogDebugS(m_pApiDelegateLogger, "MeetingApiDelegate::hasDSCapability()");
    
    bool bEnable = m_jabberServiceProvider->hasDSCapability(sessionName.c_str());
    
    CSFLogDebugS(m_pApiDelegateLogger, "MeetingApiDelegate::hasDSCapability() bEnable = " << (bEnable ? "true" : "false"));
    return bEnable;
}
    
bool MeetingApiDelegate::hasIMCapability(const PString & sessionName)
{
    CSFLogDebugS(m_pApiDelegateLogger, "MeetingApiDelegate::hasIMCapability()");
    
    bool bEnable = m_jabberServiceProvider->hasIMCapability(sessionName.c_str());
    
    CSFLogDebugS(m_pApiDelegateLogger, "MeetingApiDelegate::hasIMCapability() bEnable = " << (bEnable ? "true" : "false"));
    return bEnable;

}
    
bool MeetingApiDelegate::isBuddyOnline(const PString & sessionName)
{
    CSFLogDebugS(m_pApiDelegateLogger, "MeetingApiDelegate::isBuddyOnline() sessionName = " << sessionName.c_str());
    
    bool bOnline = m_jabberServiceProvider->isBuddyOnline(sessionName.c_str());
    
    CSFLogDebugS(m_pApiDelegateLogger, "MeetingApiDelegate::isBuddyOnline() bOnline = " << (bOnline ? "true" : "false"));
    return bOnline;
}
    
bool MeetingApiDelegate::isCupModel()
{
    CSFLogDebugS(m_pApiDelegateLogger, "Entry MeetingApiDelegate::isCupModel()")
    bool bRtn = m_jabberServiceProvider->isCupMode();
    
    CSFLogDebugS(m_pApiDelegateLogger, "MeetingApiDelegate::isCupModel() bRtn = " << (bRtn ? "true" : "false"));
    return bRtn;
}
 
bool MeetingApiDelegate::isWbxMeetingEnabled()
{
    bool bRtn = m_jabberServiceProvider->isWbxMeetingEnabled();
    CSFLogDebugS(m_pApiDelegateLogger, "MeetingApiDelegate::isWbxMeetingEnabled() bRtn = " << (bRtn ? "true" : "false"));
    return bRtn;
}

// IM command, meeting reminder related
void MeetingApiDelegate::sendMeetingReminder(const PString buddyName, const PString cmdMsg, const PString htmlMsg, const PString plantMsg)
{
    CSFLogDebugS(m_pApiDelegateLogger, "MeetingApiDelegate::sendMeetingReminder()");
	InstantMessageMgr::getInstance()->sendMeetingRemindCmd(buddyName.c_str(), cmdMsg.c_str(), htmlMsg.c_str(), plantMsg.c_str());
}

    
//private:
std::string MeetingApiDelegate::unescapeJid(const std::string & jid)
{
    std::string cJid = jid;
    
    replaceAll(cJid, "\\20", " ");
    replaceAll(cJid, "\\22", "\"");
    replaceAll(cJid, "\\26", "&" );
    replaceAll(cJid, "\\27", "'");
    replaceAll(cJid, "\\2f", "/");
    replaceAll(cJid, "\\3a", ":");
    replaceAll(cJid, "\\3c", "<");
    replaceAll(cJid, "\\3e", ">");
    replaceAll(cJid, "\\40", "@");
    replaceAll(cJid, "\\5c", "\\");
    
    return cJid;
}
    
void MeetingApiDelegate::replaceAll(std::string& target, const std::string oldstr, const std::string newstr)
{
    if(oldstr.length() == 0)
    {
        return;
    }
    
    size_t pos = 0;
    while(pos = target.find(oldstr, pos), pos != std::string::npos)
    {
        target.erase(pos, oldstr.length());
        target.insert(pos, newstr);
        pos = pos + newstr.length();
    }
}
    
}